#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Basic voronoi and worley noiseMod01.fsh  by   legoushque
//https://www.shadertoy.com/view/cslGRl
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define TAU 6.283185
#define PI 3.141526
#define T iTime*TAU*0.1


mat2 Rot(float a){
    float s = sin(a);
    float c = cos(a);
    return mat2(c, -s, s, c);
}

vec2 hash22(vec2 p){
    return vec2(
        fract(sin(dot(p, vec2(15.12312, 7.12312))*TAU*3.) * 46814.2848),
        fract(sin(dot(p, vec2(8.4124, 19.23123))*TAU*3.) * 58383.7594))-0.5;

}

vec3 hash23(vec2 p){
    return vec3(
        fract(sin(dot(p, vec2(15.12312, 7.12312))*TAU*3.) * 46814.2848),
        fract(sin(dot(p, vec2(8.4124, 19.23123))*TAU*3.) * 58383.7594),
        fract(sin(dot(p, vec2(10.4124, 15.23123))*TAU*3.) * 23383.7594));

}

//returns vec3(first closest, second closest, third closest)
vec3 worley(vec2 uv, float rotation, float distortion){
    vec2 id = floor(uv),
         gv = fract(uv); 
    float first = 100.;
    float second = 100.;
    float third = 100.;
    vec2 minid;
    for(int i = -1; i <= 1; i++)
    for(int j = -1; j <= 1; j++){
        vec2 cords = vec2(i, j);
        cords += id+0.5;
        cords += Rot(rotation)*hash22(cords)*distortion;
        float curdist = length(uv - cords);
        if(curdist < first){
            third = second;
            second = first;
            first = curdist;
            minid = id+vec2(i, j);
        } else if(curdist < second){
            third = second;
            second = curdist;
            
        } else if(curdist < third){
            third = curdist;
        }
    }
    return vec3(first, second, third);
}

// return coordinates of nearest diagram point
vec2 voronoi(vec2 uv, float rotation, float distortion){
    vec2 id = floor(uv),
         gv = fract(uv);
    float first = 100.;
    vec2 minid;
    for(int i = -1; i <= 1; i++)
    for(int j = -1; j <= 1; j++){
        vec2 cords = vec2(i, j);
        cords += id+0.5;
        cords += Rot(rotation)*hash22(cords)*distortion;
        float curdist = length(uv - cords);
        if(curdist < first){
            first = curdist;
            minid = id+vec2(i, j);
        } 
    }
    return minid;
}



//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    vec2 uv = (fragCoord-0.5*iResolution.xy)/iResolution.y;
    
       
    uv *= 7.;
    
    vec3 distances = worley(uv, T, cos(T)*0.5+0.5);
    vec3 vor = hash23(voronoi(uv, T, cos(T)*0.5+0.5));
    
         
    vec3 col = smoothstep(-0.2, 1.1, vec3(vor)) * ( 1. - smoothstep(0.1, 1.5, distances.y)) ;
    
    fragColor = vec4(col,1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

